/*  Programmer : Noel Allosa         http://www.allosa.com
    Application : Intelliball despenser  XBALL-04
    November 3, 2004                 noel_allosa@yahoo.com
*/
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <string.h>

#define Data 0x378            /* Paraller Data Outport 0x378 */
#define Status 0x379          /* Status Data Inport    0x379 */
#define Control 0x37a         /* Reserved Outport      */
#define WAIT 15               /* Hopper timer out      */
#define DATAMAX 1000          /* Maximum Record        */
#define VALIDDATALEN 10       /* Valid BAR Code LENGHT */

FILE *f1,*f2;
char *c;
char data[100],fdata[100],ddata[100];
char flname[25];
int d1,d2,d3,d4,d5,d6,d7,d8;
int s1,s2,s3,s4,s5,s6,s7,s8;
int ret;
int sum;
int exit;
int input;
int sched;
int good;
int reccount,fround;
int index,count,bfound,i,j,k;

int Giveballs();
int dport(int dx, int st);
int inportsw();
int dispense();
int reload();
int initload();
int inputscan();
int filehandling(char* f1, char* data, int max, int save);
void kbclrbuffer();

unsigned int bits;

main()
{
   int iret;
   clrscr();
   printf(" XBALL04 v 3.0 by Noel Allosa  http://www.allosa.com\r\n");
   printf(" Release 2005  http://www.angelfire.com/nc/NoelAllosa/xball/index.html\r\n");
   printf(" 1. Auto hopper shutoff.\r\n");
   printf(" 2. Clear pre-keyboard/input buffer.\r\n");
   printf(" 3. Balance ball distribution.\r\n");
   printf(" 4. Expandable DOS Turbo C Program Algorithm.\r\n\n");

   sched = 1;
   d1=0;d2=0;d3=0;d4=0;d5=0;d6=0;d7=0;d8=0;
   initload();
   strcpy(flname,"XBALL04.TXT");
   reccount = 0;
   outportb(Data,0);
   exit = 0;
   while( exit==0 )
   {
	kbclrbuffer();      /* Clear any KEYBOARD BUFFER  */
	i = inputscan();    /* Return i as LENGHT of Data */
			    /* Save the # ball in "sum"   */
	if ( i==1 )
	{
	   Giveballs();     /* 1 char data is always a valid input */
	}
	else if ( i==VALIDDATALEN )
	{                                         /* remember SAVED data  */
		iret = 0;
		strcpy(flname,"XBALL04.INI");
		iret = filehandling(flname,data,5,0);
		if (iret==-1)          /* Found in TEST CARD file, ret -1 */
		{
		    printf("NOTE: TEST CARD SCANNED\r\n");
		    i=0;
		}
		else
		{
		   strcpy(flname,"XBALL04.TXT");
		   iret = filehandling(flname,data,DATAMAX,1);
		   if (iret==0)
		   {
		      i=0;
		   }else
		   {
		      printf("ERROR: TICKET ALREADY SCANNED!\r\n");
		      i=1;
		   }
		}
	   if (i==0) Giveballs();
	}
	else
	{
	   if (i>6)
	   printf("ERROR: INVALID DATA LENGHT\r\n");
	}
   }/*while*/
}
int Giveballs()
{
	   if (sum > 4) sum = 0;
	   if (sum < 1) sum = 0;
	   good = 4;                   /* Initiate the 4 hoppers to be good */
	   if (d1==-1) good--; if (d2==-1) good--;
	   if (d3==-1) good--; if (d4==-1) good--;

	   if (good==0)
	   {
	       printf("ALL HOPPERS EMPTY\r\n"); /* No good hoppers */
	       dport(6,1);
	   }
	   if (good<4)
	   {
	       dport(7,1);
	   }
	   while (sum>0 && good>0)
	   {
	      if (good>=sum)
	      {
		input = sum;
		sum   = 0;
	      }
	      else
	      {
		input = good;
		sum   = sum-input;
	      }
	      printf("We have %d current working hopper(s).\r\n",good);
	      if (sum==0)
	      printf("Dispensing all %d ball(s) requested.\r\n",input);
	      else
	      printf("Dispensing only %d ball(s) then another %d ball(s) on next reload.\r\n",input,sum);

	      dispense();
	      printf("Reloading.  Please wait....\r\n");
	      reload();
	      if (d1==-1 && d2==-1 && d3==-1 && d4==-1)	sum=0;
	      sleep(1);
	      good = 4;                   /* Initiate the 4 hoppers to be good */
	      if (d1==-1) good--; if (d2==-1) good--;
	      if (d3==-1) good--; if (d4==-1) good--;
	      if (good==0)
	      {
		  printf("ALL HOPPERS EMPTY\r\n"); /* No good hoppers */
		  dport(6,1);
	      }
	      if (good<4)
	      {
		  dport(7,1);
	      }
	   }/*while*/
}
int inputscan()
{
   int iret;
	printf("-----------------------------------------");
	printf("-----------------------------------------");

	printf("\rInput/Scan (LAST DIGIT PROCESSING) e.g. 1 or 10 digits ==>");
	scanf("%s",&data);             /* Scan or Data Input       */
	sum = 1; fround = 0;
	i = strlen(data) - 1;
	printf("The DATA is %s with a confirm DATA Lenght of %d character(s).\r\n",data,i+1);
	   if (data[i]=='1') sum = 1;
	   if (data[i]=='2') sum = 2;
	   if (data[i]=='3') sum = 3;
	   if (data[i]=='4') sum = 4;
	   if (data[i]=='5') sum = 5;
	   if (data[i]=='6') sum = 6;
	   if (data[i]=='7') sum = 7;
	   if (data[i]=='8') sum = 8;
	   if (data[i]=='9') sum = 9;

	   if ( strcmp(data,"111104")==0 )
	   {
		dport(6,1);
		iret = 0;
		i = 1;
		printf("Scan TEST card :");
		scanf("%s",&data);
		strcpy(flname,"XBALL04.INI");
		iret = filehandling(flname,data,5,1);
		if (iret==0)
		{
		   printf("Test CARD SAVED!\r\n");
		}else
		{
		   printf("Duplicate: Already a TEST CARD\r\n");
		}
		dport(6,0);
	   }
   return i+1;
}
int dispense()
{
    int xtempsched;
	xtempsched = sched;
	dport(5,1);
	sleep(1);
	for (i=0; i<input; i++)
	{
	   for(j=0; j<4; j++)
	   {
		sched++;
		if (sched>4) sched=1;
		if (sched==1 && d1==0){ printf("Solenoid 1 Energized!\r\n"); break;}
		if (sched==2 && d2==0){ printf("Solenoid 2 Energized!\r\n"); break;}
		if (sched==3 && d3==0){ printf("Solenoid 3 Energized!\r\n"); break;}
		if (sched==4 && d4==0){ printf("Solenoid 4 Energized!\r\n"); break;}
	   }
		dport(sched,1);
		sleep(1);
		dport(sched,0);
	}
	sleep(1);
	dport(5,0);
	sleep(1);
	      if (good<4 && fround==0)     /* Check if the Working HOPPERS     */
	      {               /* Lit the WARNING lights for 1 sec */
		   dport(6,1);
		   sleep(1);
		   dport(6,0);
		   sleep(1);
		   fround=1;
	      }

	sched = xtempsched;
	for (i=0; i<input; i++)
	{
	   for(j=0; j<4; j++)
	   {
		sched++;
		if (sched>4) sched=1;
		if (sched==1 && d1==0){ printf("RUN  Hopper #1!\r\n"); break;}
		if (sched==2 && d2==0){ printf("RUN  Hopper #2!\r\n"); break;}
		if (sched==3 && d3==0){ printf("RUN  Hopper #3!\r\n"); break;}
		if (sched==4 && d4==0){ printf("RUN  Hopper #4!\r\n"); break;}
	   }
		dport(sched,1);
	}
   return 0;
}
int initload()
{
   dport(8,1);
   inportsw();
   if (s4==0) { dport(1,1);  printf("RUN INITIALIZE Hopper #1.\r\n");}
   if (s5==0) { dport(2,1);  printf("RUN INITIALIZE Hopper #2.\r\n");}
   if (s6==0) { dport(3,1);  printf("RUN INITIALIZE Hopper #3.\r\n");}
   if (s7==0) { dport(4,1);  printf("RUN INITIALIZE Hopper #4.\r\n");}
   printf("\r\nReloading.  Please wait....\r\n");
   sum = 0;
   reload();
   if (d1==-1) sched=1;
   if (d2==-1) sched=2;
   if (d3==-1) sched=3;
   if (d4==-1) sched=4;
   return 0;
}
int reload()
{
   dport(8,1);

   for (i=0; i<WAIT; i++)
   {
       inportsw();

       if (s4==1 && d1==1) {dport(1,0);  printf("RELOADED Solenoid/Hopper #1. Ball Presence SW1 ON.\r\n");}
       if (s5==1 && d2==1) {dport(2,0);  printf("RELOADED Solenoid/Hopper #2. Ball Presence SW2 ON.\r\n");}
       if (s6==1 && d3==1) {dport(3,0);  printf("RELOADED Solenoid/Hopper #3. Ball Presence SW3 ON.\r\n");}
       if (s7==1 && d4==1) {dport(4,0);  printf("RELOADED Solenoid/Hopper #4. Ball Presence SW4 ON.\r\n");}
       if (d1<=0 && d2<=0 && d3<=0 && d4<=0){ printf("=OK=\r\n"); break; }
       sleep(1);
   }
   dport(8,0);
	if (i>=WAIT)
	{
		if (d1==1) { dport(1,0); d1=-1; printf("Hopper #1 TIMEOUT! Disabled!\r\n");}
		if (d2==1) { dport(2,0); d2=-1; printf("Hopper #2 TIMEOUT! Disabled!\r\n");}
		if (d3==1) { dport(3,0); d3=-1; printf("Hopper #3 TIMEOUT! Disabled!\r\n");}
		if (d4==1) { dport(4,0); d4=-1; printf("Hopper #4 TIMEOUT! Disabled!\r\n");}
	}
   return 0;
}
int dport (int dx, int st)
{
   int byte = 0;
   if (st==1)
   {
	switch( dx )
	{
	   case 1: if (d1==0) d1=1; break;
	   case 2: if (d2==0) d2=1; break;
	   case 3: if (d3==0) d3=1; break;
	   case 4: if (d4==0) d4=1; break;
	   case 5: if (d5==0) d5=1; break;
	   case 6: if (d6==0) d6=1; break;
	   case 7: if (d7==0) d7=1; break;
	   case 8: if (d8==0) d8=1; break;
	}
   }else
   {
	switch( dx )
	{
	   case 1: if (d1==1) d1=0; break;
	   case 2: if (d2==1) d2=0; break;
	   case 3: if (d3==1) d3=0; break;
	   case 4: if (d4==1) d4=0; break;
	   case 5: if (d5==1) d5=0; break;
	   case 6: if (d6==1) d6=0; break;
	   case 7: if (d7==1) d7=0; break;
	   case 8: if (d8==1) d8=0; break;
	}
   }
   if (d1==1) byte = byte + 1;
   if (d2==1) byte = byte + 2;
   if (d3==1) byte = byte + 4;
   if (d4==1) byte = byte + 8;
   if (d5==1) byte = byte + 16;
   if (d6==1) byte = byte + 32;
   if (d7==1) byte = byte + 64;
   if (d8==1) byte = byte + 128;
   outportb(Data,byte);
   return byte;
}
int inportsw()
{
   int j;
   s1=0;s2=0;s3=0;s4=0;s5=0;s6=0;s7=0;s8=0;
   bits = inportb(Status);
		if (bits >= 128)
		{
			s8 = 1; bits = bits-128;
		}
		if (bits >= 64)
		{
			s7 = 1; bits = bits-64;
		}
		if (bits >= 32)
		{
			s6 = 1; bits = bits-32;
		}
		if (bits >= 16)
		{
			s5 = 1; bits = bits-16;
		}
		if (bits >= 8)
		{
			s4 = 1; bits = bits-8;
		}
		if (bits >= 4)
		{
			s3 = 1; bits = bits-4;
		}
		if (bits >= 2)
		{
			s2 = 1; bits = bits-2;
		}
		if (bits >= 1)
		{
			s1 = 1;
		}
   return 0;
}
void kbclrbuffer()
{
   while (kbhit()!=0)             /* Clear any keyboard input */
   {
      getch();
   }
}
/* Parameters  : filename,   data,  maxrecord       */
/* Return      : 0 = OK,  -1 = NOGOOD (data found)  */
int filehandling(char* fn, char* data, int max, int save)
{
    int recno,i,j,k,bfound;
    recno = 0;
    bfound = 0;
    f1 = fopen(fn,"r");
    if (f1==NULL)
    {
       f1 = fopen(fn,"w");
       fputs("---",f1);
       fputc('\n',f1);
       fclose(f1);
       f1 = fopen(fn,"r");
    }
    j = strlen(data);
    /*-----------------------------------*/
    do{
	c = fgets(fdata,30,f1);
	if (c==NULL) break;
	k = strlen(fdata);
	if ( (j+1) == k )
	{
		for (i=0; i<j; i++)
		{
		    if (data[i]!=fdata[i])
		    {
			 break;
		    }
		    if ( i > k ) break;
		}
		if (i==j) bfound=-1;
	}
	recno++;
    }while (bfound==0);
    /*-----------------------------------*/
    fclose(f1);
    if (bfound==0 && save==1)   /* NOT FOUND and SAVE APPEND */
    {
	    f2 = fopen(fn,"a");
	    if (f2!=NULL)
	    {
	       fputs(data, f2);
	       fputc('\n',f2);
	       fclose(f2);
	       recno++;
	    }
       if (recno > max)   /* Determine the MAX record */
       {
	   f1 = fopen(fn,"r");
	   f2 = fopen("TEMP.TXT","w");   /* Open TEMPORARY FILE */
	   i  = 1;
	   do{
	      c = fgets(fdata,30,f1);
	      if (c==NULL) break;
	      if ( i > recno-max )
	      {
		   fputs(fdata, f2);
	      }
	      i++;
	   } while (1);
	   fclose(f1);
	   fclose(f2);
	   unlink(fn);
	   rename("TEMP.TXT",fn);        /* Make the TEMP be the work file */
       }
    }
    return bfound;    /* Return 0 or -1  */
}
